'***************************************
'***************************************
'* System: MMBasic 5,05 for CMM2
'* twofingers at TBS 08-2014/08-2020
'* No warranty, provided at your own risk.
'*       This code may be freely 
'*     distributed without charge 
'*
'*          John Conway's
'*      "Game of Life" v2.02
'*
'*   a code example/benchmark
'***************************************
'Rules (https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life)
'1. Any live cell with two or three live neighbours survives.
'2. Any dead cell with three live neighbours becomes a live cell.
'3. All other live cells die in the next generation. 
'   Similarly, all other dead cells stay dead.
'***************************************
'***************************************
'see also https://conwaylife.com/ref/lexicon/lex_home.htm
'***************************************


Option base 0
Option explicit
Mode 1,8


CONST TRUE =1
CONST FALSE=not TRUE

CONST DEBUG =FALSE

DIM INTEGER e_Flag               ' editor exit control

DIM INTEGER C_x,C_y,C_x1,C_y1    ' field dimensions, inner field dimensions,
DIM INTEGER f,sx                 ' toggle array, 1<<(64-x)

DIM INTEGER tsum                 ' time
DIM INTEGER y,x,i                ' for/next
DIM INTEGER fw=mm.info(FONTWIDTH)' font width
DIM INTEGER d,gen                ' number of neighbors, generations
DIM STRING  Titel$               ' Prg. Titel
DIM INTEGER a1(2),a2(2)          ' Limits 2-max field width

'DIM INTEGER a=0,b=0,c=0          ' for COUNTN() - obsolete
'DIM INTEGER t0=1,t1=1,t2=1       ' for COUNTN() - obsolete
'DIM INTEGER ret=0                ' for COUNTN() - obsolete

DIM INTEGER cr,cc,key            ' for life_edit


DIM INTEGER small=0,med=1,big=2
DIM INTEGER CXY(2,1)=(40,50,64,25,35,64)

DIM INTEGER SIZE=med

DIM INTEGER P(64) ' World A
DIM INTEGER O(64) ' World B
DIM INTEGER r(64) ' array for demo patterns

                 '***************************************
                 '****** plz edit field dimensions ******
                 '*** smaller field = faster ************
C_x =CXY(size,0) ' entire field width w. border (max=64)
C_y =CXY(size,1) ' entire field height w. border (max=64)
                 '***************************************
C_x1=C_x -1      ' entire field width w/o. border (max=62)
C_y1=C_y -1      ' entire field height w/o border (max=62)

DIM STRING TEMP$

do '********** Mainloop ***************

 do
   MainScreen()
 loop while not e_flag

 page write 1

 println(80,20+2,"ESC   =  Exit",0)  

'********** Show the GOL World ***************
 Do
  Timer=0

  box 12,12,C_x1*6-4,C_y1*8+6,0,,rgb(blue)

  For x=a1(f) To a2(f) Step 1-f*2
   sx = 1<<(64-x)
   For y=2 To C_y1
     cn(o(),y,x,d)       ' CSub for counting neigbours
    'countn(o(),y,x,d)   ' Basic sub - observe DIM's!
    if (o(y) and sx)=0  then    
      If d=3 Then p(y)=p(y) or sx ''new cell
    Else
      plotxy (x,y)
      If d=2 Or d=3 Then p(y)=p(y) or sx
    EndIf
   Next
  Next
  page copy 1 to 0

'  for i=0 to c_y1:o(i)=p(i):next 'copy world (pure Basic)
'  acopy(p(),o(),c_y1) ' csub array copy - copy world
  math scale p(),1,o() ' array copy - copy world


  ClearWorld p()
  f=not f '0,1,0,1,0,...
  gen=gen+1
  tsum=tsum+Timer

  println(3,C_y+3,Str$(f)+"  gen:"+Str$(gen),0);
  println(22,C_y+3," tm:"+Str$(Cint(Timer))+"ms ",0)
  println(35,C_y+3,"avg:"+Str$(Int(tsum*10/gen)/10)+"ms  ",0)

 'do:loop while inkey$<>chr$(32) ' single step
 'save image str$(gen)+".bmp"    ' take screenshots

  key=asc(inkey$)
  if key = 27 then 
    page write 0:println(80,20+4,"SPACE =  Continue",0):page write 1
    do:TEMP$=inkey$:loop while TEMP$<>chr$(27) and TEMP$<>chr$(32)
  endif 

 Loop while Temp$<>chr$(27)
 TEMP$=""
 page write 0:cls:page write 1
 ClearWorld o()

loop  '********** END Mainloop *************

end 


'countn 155 bzw. 148ms/1000 ---- unused ----
sub countn (t() as integer, y as integer,x as integer,n as integer)
a=1<<63-x:b=a<<1:c=b<<1:n=8
t0=t(y-1):t1=t(y):t2=t(y+1)
n=n-((t1 and c)=0)
n=n-((t1 and a)=0)
n=n-((t0 and c)=0)
n=n-((t2 and c)=0)
n=n-((t0 and b)=0)
n=n-((t2 and b)=0)
n=n-((t0 and a)=0)
n=n-((t2 and a)=0)
end sub 


Sub plotxy (x,y) ' display cell
  CIRCLE x*6+3,y*8+4,2,,,rgb(RED), rgb(YELLOW)
End Sub


Sub Cplotxy (x,y) 'editor cursor
  CIRCLE x*6+3,y*8+4,2,,,rgb(white), rgb(black)
End Sub

Sub Cplotxydel (x,y)'editor cursor
  CIRCLE x*6+3,y*8+4,2,,,rgb(white), rgb(white)
End Sub

Sub Dplotxydel (x,y)'editor cursor
  CIRCLE x*6+3,y*8+4,2,,,rgb(RED), rgb(white)
End Sub



Sub ClearWorld (w() as integer)
local integer y 
  For y = 0 To C_y1
      w(y)=0
  Next
end Sub


' **** Println (col, row, string$, invers) ****
Sub Println (x,y,s$,invers)
  if invers then 
    color rgb(black),rgb(white)
  else
    color rgb(white),rgb(black)   
  endif
  Print @(x*6,y*8) s$
  color rgb(white),rgb(black)   
End Sub


' **** wait or wait + text (center and bottom of screen) ****
Sub wait prompt$
  If prompt$<>"" Then Print @((MM.HRes-Len(prompt$))/2,MM.VRes-12) prompt$;
  Do While Inkey$="":Loop
  If prompt$<>"" Then Print @((MM.HRes-Len(prompt$))/2,MM.VRes-12) String$(Len(prompt$)," ");
  Print @(0,MM.VRes-2);
End Sub


' **** initial filling ****
Sub DRandom ' Random world
local integer x,y  
local float population_density,r
  population_density=0.20
  For x = 2 To C_x1
    sx = 1<<(63-x+1)
    For y = 2 To C_y1
      r=Rnd(randomize) 
      If r<population_density Then         
        p(y)=p(y) or sx
      EndIf
    Next
  Next
End Sub


Sub Demo1       ' Pentadecathlon, a period 15 oscillator
local lines=3,wd=8
r(0)=&B1111111100000000000000000000000000000000000000000000000000000000
r(1)=&B1011110100000000000000000000000000000000000000000000000000000000
r(2)=&B1111111100000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub

Sub Demo2       ' Acorn
local lines=3,wd=8
r(0)=&B0100000000000000000000000000000000000000000000000000000000000000
r(1)=&B0001000000000000000000000000000000000000000000000000000000000000
r(2)=&B1100111000000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub

Sub Demo3       ' R-pentomino, use a big world! 
local lines=3,wd=3
r(0)=&B0110000000000000000000000000000000000000000000000000000000000000
r(1)=&B1100000000000000000000000000000000000000000000000000000000000000
r(2)=&B0100000000000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub

Sub Demo4       ' double U
local lines=7,wd=3
r(0)=&B1110000000000000000000000000000000000000000000000000000000000000
r(1)=&B1010000000000000000000000000000000000000000000000000000000000000
r(2)=&B1010000000000000000000000000000000000000000000000000000000000000
r(3)=&B0000000000000000000000000000000000000000000000000000000000000000
r(4)=&B1010000000000000000000000000000000000000000000000000000000000000
r(5)=&B1010000000000000000000000000000000000000000000000000000000000000
r(6)=&B1110000000000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub

Sub Demo42     ' Name: 42
'Demo42
local lines=5,wd=8
r(0)=&B1010011100000000000000000000000000000000000000000000000000000000
r(1)=&B1010000100000000000000000000000000000000000000000000000000000000
r(2)=&B1110011100000000000000000000000000000000000000000000000000000000
r(3)=&B0010010000000000000000000000000000000000000000000000000000000000
r(4)=&B0010011100000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub


Sub Demo5    
'MWSS Middle weight spaceship
local lines=5,wd=30
r(0)=&B0010000000000000000000000000000000000000000000000000000000000000
r(1)=&B1000100000000000000000000000000000000000000000000000000000000000
r(2)=&B0000010000000000000000000000000000000000000000000000000000000000
r(3)=&B1000010000000000000000000000000000000000000000000000000000000000
r(4)=&B0111110000000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub


Sub DemoX       ' ????
local lines=5,wd=6
r(0)=&B1110100000000000000000000000000000000000000000000000000000000000
r(1)=&B1000000000000000000000000000000000000000000000000000000000000000
r(2)=&B0001100000000000000000000000000000000000000000000000000000000000
r(3)=&B0110100000000000000000000000000000000000000000000000000000000000
r(4)=&B1010100000000000000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub


Sub DemoX1       ' Gospers glider gun
local lines=9,wd=36,xx
'      1234567890123456789012345678901234567890123456789012345678901234
'      0        1         2         3         4         5         6
r(0)=&B0000000000000000000000001000000000000000000000000000000000000000
r(1)=&B0000000000000000000000101000000000000000000000000000000000000000
r(2)=&B0000000000001100000011000000000000110000000000000000000000000000
r(3)=&B0000000000010001000011000000000000110000000000000000000000000000
r(4)=&B1100000000100000100011000000000000000000000000000000000000000000
r(5)=&B1100000000100010110000101000000000000000000000000000000000000000
r(6)=&B0000000000100000100000001000000000000000000000000000000000000000
r(7)=&B0000000000010001000000000000000000000000000000000000000000000000
r(8)=&B0000000000001100000000000000000000000000000000000000000000000000
transfer(lines,wd)
end sub


sub transfer(lines,wd) ' copy pattern to the real world
local i=0
  For y = C_y1/2-lines/2+1 to C_y1/2+lines/2   
     o(y) = r(i)>>(c_x1/2-wd/2)
     i=i+1
  Next
end sub


' count neighbours
'    cn array(), y, x, n_return
CSUB cn integer, integer , integer, integer
  00000000
  'countn
  0FB0E92D AF00B0A1 65B965F8 653B657A 0201F04F 0300F04F 231EE9C7 677B2300 
  673B2300 E9D7E00A EB12231E EB430A02 E9C70B03 6F3BAB1E 673B3301 461C6F3B 
  0500F04F E9D36D7B F04F0100 F04F023F EBB20300 EB630800 45440901 0309EB75 
  E9D7DBE1 1891231E 415B60B9 E9D760FB E9C73402 E9D7341A 1891231A 415B6039 
  E9D7607B E9C73400 6DBB3418 2300E9D3 00DA4613 44136DFB 0100E9D3 2318E9D7 
  0402EA00 400B64BC E9D764FB 43233412 6F7BD002 677B3301 E9D36DBB 46132300 
  6DFB00DA E9D34413 E9D70100 EA00231E 643C0402 647B400B 3410E9D7 D0024323 
  33016F7B 6DBB677B 2300E9D3 4360F06F 00DB4413 44136DFA 0100E9D3 2318E9D7 
  0402EA00 400B63BC E9D763FB 4323340E 6F7BD002 677B3301 E9D36DBB 46132300 
  00DB3301 44136DFA 0100E9D3 2318E9D7 0402EA00 400B633C E9D7637B 4323340C 
  6F7BD002 677B3301 E9D36DBB F06F2300 44134360 6DFA00DB E9D34413 E9D70100 
  EA00231A 62BC0402 62FB400B 340AE9D7 D0024323 33016F7B 6DBB677B 2300E9D3 
  33014613 6DFA00DB E9D34413 E9D70100 EA00231A 623C0402 627B400B 3408E9D7 
  D0024323 33016F7B 6DBB677B 2300E9D3 4360F06F 00DB4413 44136DFA 0100E9D3 
  231EE9D7 0402EA00 400B61BC E9D761FB 43233406 6F7BD002 677B3301 E9D36DBB 
  46132300 00DB3301 44136DFA 0100E9D3 231EE9D7 0402EA00 400B613C E9D7617B 
  43233404 6F7BD002 677B3301 461A6F7B 73E2EA4F E9C16D39 BF002300 46BD3784 
  0FB0E8BD 43474770 
End CSUB



Function Menue()
CONST CHOICES=10
local INTEGER fh=mm.info(FONTHEIGHT)
local INTEGER hp=80,vp=8,i
local STRING key$
local STRING MText$(CHOICES)=(" RANDOM "," DEMO1  "," DEMO2  "," DEMO3  "," DEMO4  "," DEMO42 "," DEMO5  "," DEMOX  "," DEMOX1 "," EDITOR ","> Quit <")
local STRING UP$=chr$(128)
local STRING DN$=chr$(129)

  menue=0
  box hp*6-8,vp*8-16,10*8,vp+fh*16,2,,rgb(black)

  println(hp+1,vp-3," MENUE ",1)
  println(hp,vp,MText$(0),1)

  for i = 1 to CHOICES
    println(hp,vp+i*2,MText$(i),0)
  next i
  do 
    do:key$ =inkey$:loop while key$=""
    if key$ =UP$ and menue=0 then 'up
      println(hp,vp+(menue)*2,MText$(menue),0)   
      menue=CHOICES:key$=""
      println(hp,vp+(menue)*2,MText$(menue),1)
    endif
    if key$ =UP$ and menue>0 then 'up
      println(hp,vp+(menue)*2,MText$(menue),0)   
      menue=menue-1
      println(hp,vp+(menue)*2,MText$(menue),1)
    endif
    if key$ =DN$ and menue=CHOICES then 'down
      println(hp,vp+(menue)*2,MText$(menue),0)   
      menue=0:key$=""
      println(hp,vp+(menue)*2,MText$(menue),1)
    endif
    if key$ =DN$ and menue<CHOICES then 'down
      println(hp,vp+(menue)*2,MText$(menue),0)  
      menue=menue+1
      println(hp,vp+(menue)*2,MText$(menue),1)
    endif
  loop while key$<>chr$(13) 'or e_flag'enter
End Function '------- Menue() --------


sub Life_Edit() ' create your own patterns
  cr=2'cursor row
  cc=2'cursor col

  cls
  ClearWorld r()

  box 6,6,C_x*6+2,C_y*8+12,0,,rgb(BLUE)
  box 12,12,C_x1*6-4,C_y*8,0,,rgb(WHITE)

  Keyhelp()

  do 
    if r(cr) and 1<<65-cc then Dplotxydel(cc,cr) else Cplotxydel(cc,cr) 
    key=asc(inkey$) 
    if key<>0 then Keyhandler(key)
    cplotxy(cc,cr)
  loop until key=27 or e_flag
end sub '-------- Life_Edit() ------------


sub Keyhelp() ' show which keys are used in the editor
local STRING KHelp$(20)
local INTEGER i
local INTEGER hp=80,vp=8

  box hp*6-8,vp*8-8,10*20,vp+8*32,2,,rgb(black)

  println(80,6,"     Keyboard help     ",1)  

  KHelp$(0)="Home        cursor"
  KHelp$(1)="End         cursor"
  KHelp$(2)="Page Up     cursor"
  KHelp$(3)="Page Down   cursor"
  KHelp$(4)="Down Arrow  cursor"
  KHelp$(5)="Left Arrow  cursor"
  KHelp$(6)="Right Arrow cursor"
  KHelp$(7)="C = Center  cursor"
  KHelp$(8)="Space = set/reset cell"
  KHelp$(9)="Enter=set cell + move >"
  KHelp$(10)="Plus=set cell+move down"
  KHelp$(11)="L = Load pattern (join)"
  KHelp$(12)="S = Save pattern"
  KHelp$(13)="K = Kill all"
  KHelp$(14)="E = Execute"
  KHelp$(15)="ESC = Leave editor"

  for i =0 to 15
     println(80,8+i*2,KHelp$(i),0)  
  next i
end sub


sub Keyhandler(key) 'for editor
local INTEGER x,y,x1,y1
local STRING GOL$,remark$

 if not (r(cr) and 1<<65-cc) then cplotxydel(cc,cr)

 select case key
  case 134 'Home
   if cc=2 then cr=2
   cc=2':cr=2
  case 135 'End
   cc=c_x1
  case 136 'Page Up
   cr=2
  case 137 'Page Down
   cr=c_y
  case 128 'Up
   if cr>2 then cr=cr-1
  case 129 'Down
   if cr<=c_y1 then cr=cr+1
  case 130 'left
   if cc>2 then cc=cc-1
  case 131 'rt
   if cc<c_x1 then cc=cc+1    
  case 32,13,43 'space,enter,plus
    plotxy(cc,cr)
    r(cr)=r(cr) xor 1<<65-cc
    if key=13 and cc<c_x1 then cc=cc+1
    if key=43 and cr<=c_y1 then cr=cr+1
  case 27 'ESC
    clearworld r()
    e_Flag=FALSE
    exit sub
  case asc("S"), asc("s")' save
    on error skip
    open "LIFE.GOL" for output as #1    
    if mm.errno = 0 then
       PRINT #1,"Remark"
       PRINT #1,C_y1
       PRINT #1,C_x1
       for i = 0 to C_y1
         PRINT #1, bin$(r(i),64)
       next i
      close #1
    endif
    ShowMsg(MM.ERRMSG$)
  case asc("l"), asc("L")' Add load (JOIN)
    if mm.info(filesize "Life.GOL")<>-1 then 'file exist
       box 12,12,C_x1*6-4,C_y*8,0,,rgb(WHITE)
       open "LIFE.GOL" for input as #1    
       input #1,remark$
       input #1,y
       input #1,x
       for y1 = 0 to c_y1
         input #1, gol$
         r(y1)=r(y1) or val("&B"+gol$)
         for x1=0 to c_x1
           if r(y1) and 1<<65-x1 then plotxy(x1,y1)
         next x1
       next y1
       close #1
 save image "life.bmp"    ' take screenshots

    else
       ShowMsg("Error: GOL File not found")
    endif
  case asc("k"), asc("K")' Kill all
    clearworld r()
    box 12,12,C_x1*6-4,C_y*8,0,,rgb(WHITE)
  case asc("c"), asc("C")' center
    cc=c_x/2+1
    cr=c_y/2
  case asc("e"), asc("E")' execute
    transfer(c_y1+2,c_x1-1)
    e_Flag=TRUE
    exit sub
  case else  
 end select 
end sub ' ****** editors keyhandler 


sub ShowMsg(msg$)
local integer i
 for i = 1 to 3
    println(3,C_y+3,Msg$,i mod 2)
    pause 500
 next
    println(3,C_y+3,space$(len(Msg$)),0)'
end sub


sub MainScreen()

   cls
   e_flag  =TRUE

   ClearWorld p() 'reset all cells to zero
   gen=0:Timer=0:tsum=0
   page write 1
   cls
   box 6,6,C_x*6+2,C_y*8+10,6,,rgb(WHITE)
   page write 0
   box 6,6,C_x*6+2,C_y*8+10,6,,rgb(WHITE)

   a1(0)=2:a2(0)=C_x1
   a1(1)=C_x1:a2(1)=2

   Font #2,1:fw=11
   Titel$=" The Game of LIFE "
   Print @((C_x*6/2)-(Len(Titel$)/2*fw)-2,50) Titel$
   Font #1

   select case menue()
     case 0
       DRandom'Random world
     case 1
       Demo1  'Pentadecathlon
     case 2
       Demo2  'Acorn
     case 3
       Demo3  'r-Pentomino
     case 4
       Demo4  ' double U
     case 5
       Demo42 ' 42
     case 6
       Demo5  ' MWSS
     case 7
       DemoX  ' ???
     case 8
       DemoX1 'glider gun
     case 9
       e_flag=FALSE
       life_edit()
     case 10
       PRINT @(0,c_y*8)
      end '------- THIS IS THE END ----------
   end select

end sub 'MainScreen
